<?php
/* Custom functions code goes here. */
if ( ! function_exists( 'my_mce4_options' ) ) {
    function my_mce4_options( $init ) {
        // Les couleurs par défaut
        $default_colours = '
            "000000", "Black",
            "993300", "Burnt orange",
            "333300", "Dark olive",
            "003300", "Dark green",
            "003366", "Dark azure",
            "000080", "Navy Blue",
            "333399", "Indigo",
            "333333", "Very dark gray",
            "800000", "Maroon",
            "FF6600", "Orange",
            "808000", "Olive",
            "008000", "Green",
            "008080", "Teal",
            "0000FF", "Blue",
            "666699", "Grayish blue",
            "808080", "Gray",
            "FF0000", "Red",
            "FF9900", "Amber",
            "99CC00", "Yellow green",
            "339966", "Sea green",
            "33CCCC", "Turquoise",
            "3366FF", "Royal blue",
            "800080", "Purple",
            "999999", "Medium gray",
            "FF00FF", "Magenta",
            "FFCC00", "Gold",
            "FFFF00", "Yellow",
            "00FF00", "Lime",
            "00FFFF", "Aqua",
            "00CCFF", "Sky blue",
            "993366", "Brown",
            "C0C0C0", "Silver",
            "FF99CC", "Pink",
            "FFCC99", "Peach",
            "FFFF99", "Light yellow",
            "CCFFCC", "Pale green",
            "CCFFFF", "Pale cyan",
            "99CCFF", "Light sky blue",
            "CC99FF", "Plum",
            "FFFFFF", "White"
        ';
    
        // Les couleurs personnalisées
        $custom_colours = '
            "ECECEC", "Oxygen 1",
            "00B6DD", "Oxygen 2",
            "006481", "Oxygen 3",
            "424242", "Color 4 Name",
            "FFFFFF", "Color 5 Name",
            "FFFFFF", "Color 6 Name",
            "FFFFFF", "Color 7 Name",
            "FFFFFF", "Color 8 Name"
        ';

        $init['textcolor_map'] = '['.$default_colours.','.$custom_colours.']';
        $init['textcolor_rows'] = 6; // On étend le nombre de lignes de couleurs à 6

        return $init;
    }
}
add_filter('tiny_mce_before_init', 'my_mce4_options');

function translate_footer( $footer ) {
	if( qtrans_getLanguage() == 'en' ){ 
		$footer=str_replace('Charte de confidentialité','Privacy Policy',$footer);
		$footer=str_replace('Mentions légales','Terms of use',$footer);
	}    
	if( qtrans_getLanguage() == 'es' ){ 
		$footer=str_replace('Charte de confidentialité','Política de privacidad',$footer);
		$footer=str_replace('Mentions légales','Condiciones de uso',$footer);
	}    
	return $footer;
}

add_filter( 'us_footer_the_content', 'translate_footer' );

